include RX_Decoder.inc
;==================================================================
;==================================================================
PUBLIC	Rx_ISR
;;PUBLIC	_Process_RF_packet

if(start_format==3)
START_H_CNT		EQU		1	
START_L_CNT		EQU	   10	
endif

;Bit_Format
DTA_0_H_CNT		EQU		2	
DTA_0_L_CNT		EQU		1	
DTA_1_H_CNT		EQU		1	
DTA_1_L_CNT		EQU		2	

DTA_HL_CNT		EQU		1	
DTA_WIDTH_CNT	EQU		3
;--------------------------------------------------------
ERR_CNT			EQU		((TXN+2)/3)	
START_ERR_CNT	EQU		((START_L_CNT*TXN+2)/3)
;==================================================================
DATA1		.SECTION	'data'

mSTS1		db		?
mACC1		db		?

_mRFData		DB		9 dup(?)
public	_mRFData

mTRxBits	DB		?
mTRxCnt		DB		?
mTRxLoCnt	DB		?
mTRxHiCnt	DB		?

fTRxTgl		dbit
fTRxLevel	dbit

extern _RF_Flag			:byte
fReceived 	equ _RF_Flag.0
fDataok	    equ _RF_Flag.1
fRxBusy	    equ _RF_Flag.2

fRxstep		dbit
flastbit	dbit
extern _RX_Window_Flag			:bit
window_count db		?

mData		db		?
V_temp	    DB		?
mBrig		db		?

CODE	    .SECTION  PARA	'code'  ;	
		
;==================================================================
; RX ISR : 
;==================================================================
Rx_ISR:
			SNZ		RX_TMF
			RETI
		    CLR		RX_TMF
		    
			
				    
	    	mov		a,ACC
	    	mov		mACC1,A
	    	mov		a,STATUS
	    	mov		mSTS1,A
    	
;-------- Rx Begin
	Rx_Begin:
            SNZ		RFDATA
            JMP		Rx_Lo
		Rx_Hi:		
			SZ		fTRxLevel
			JMP		$1
			SET		fTRxLevel
			SET		fTRxTgl
			JMP		RxProcedure
			
		$1:			
			INC		mTRxHiCnt
			JMP		RxProcedure
		
		Rx_Lo:
if(Bit_Format==2)
			sz		flastbit
			jmp		lastbit	
ENDIF				
			SNZ		fTRxLevel
			JMP		$0			
			CLR		fTRxLevel
			SET		fTRxTgl
			JMP		RxProcedure

		$0:			
			INC		mTRxLoCnt ;[0]
			JMP		RxProcedure

lastbit:
			SET		fTRxLevel
			SET		fTRxTgl		
;==================================================================
;==================================================================		
RxProcedure:
			SNZ		fTRxTgl
			JMP		Rx_End
			
			CLR		fTRxTgl			

			SNZ		fTRxLevel			
			JMP		Rx_End
			
;======================my Charge			
			SNZ		_RX_Window_Flag
			JMP		rp_ChkDta
			
IF(start_format==3)			
			SZ		fRxstep
			JMP		rp_cnt
		
			
			MOV		A,mTRxLoCnt;[0]
			SUB		A,(START_L_CNT*TXN)-START_ERR_CNT
			SNZ		C
			JMP		rp_Lp0
			
		rp_cnt:
			snz		fRxstep
			JMP		rp_ChkStr
ENDIF
			JMP		rp_ChkDta
					
	rp_Lp_rst:
			CLR		fRxstep
	        CLR     flastbit           ;;0709
	rp_Lp0:
			CLR		mTRxBits
	
	rp_Lp0_c:
			CLR		mTRxHiCnt
			CLR		mTRxLoCnt;[0]
			
;======================  my Charge	
			SNZ		_RX_Window_Flag
			CLR		window_count
			
			JMP		Rx_End	
					
IF(start_format==3)							
rp_ChkStr:				 
			MOV		A,mTRxHiCnt
			SUB		A,(START_H_CNT*TXN)-ERR_CNT
			SNZ		C
			JMP		rp_Lp_rst
	
			MOV		A,mTRxHiCnt
			SUB		A,(START_H_CNT*TXN)+ERR_CNT+1
			SZ		C
			JMP		rp_Lp_rst
			
			MOV		A,mTRxLoCnt;[0]
			SUB		A,(START_L_CNT*TXN)+START_ERR_CNT
			SZ		C
			JMP		rp_Lp_rst
						
			CLR		mTRxBits					
			set		fRxstep		
			JMP		rp_Lp0
endif						
rp_ChkDta:		

			MOV		A,mTRxHiCnt
			SUB		A,(DTA_HL_CNT*TXN)-ERR_CNT
			SNZ		C
		
			JMP		rp_Lp_rst
				
			MOV		A,mTRxHiCnt
			ADD		A,mTRxLoCnt;[0]
			SUB		A,(DTA_WIDTH_CNT*TXN)+ERR_CNT+1
			SZ		C
			JMP		rp_Lp_rst
		
		
;====================== my Charge				
Window_FlaG_0:	
			;count++
			SZ		_RX_Window_Flag
			JMP		Continue		
			INC		window_count
			MOV		A,window_count
			SUB		A,10
			SZ		C
			JMP		rp_ChkDta	
			
			SET		_RX_Window_Flag
			CLR		window_count
			JMP		Rx_End
			
		Continue:	
			
if(Bit_Format==2)
			sz		flastbit
			jmp		LastBitCheck			
			MOV		A,mTRxLoCnt
			SUB		A,mTRxHiCnt;[0]
			jmp		Data_Shift
	LastBitCheck:
			MOV		A,(TXN+ERR_CNT)     ;(TXN*2)  
			SUB		A,mTRxHiCnt

	Data_Shift:		
ENDIF			
	
			RRC		_mRFData[0]
			RRC		_mRFData[1]
			RRC		_mRFData[2]			
			RRC		_mRFData[3]
			RRC		_mRFData[4]
						
			RRC		_mRFData[5]
			RRC		_mRFData[6]
			RRC		_mRFData[7]
			RRC		_mRFData[8]	
						
			INC		mTRxBits
			
						
if(Bit_Format==2)		
			MOV		A,(Encrypted_C+Fixed_C+STATUS_Bit-1)
			XOR		A,mTRxBits
			SZ		Z
			set		flastbit							
ENDIF	

	
			MOV		A,mTRxBits
			SUB		A,(Encrypted_C+Fixed_C+STATUS_Bit)   ;DATA BITS
			SNZ		C
			JMP		rp_Lp0_c
									
			CLR		mTRxHiCnt
			CLR		mTRxLoCnt;[0]

            CLR     C
            MOV     A,7
            MOV     V_temp,A
Data_RRC:            
            SDZ     V_temp
            JMP     $+2
            JMP     Data_Done
			RRC		_mRFData[0]
			RRC		_mRFData[1]
			RRC		_mRFData[2]			
			RRC		_mRFData[3]
			RRC		_mRFData[4]		
			RRC		_mRFData[5]
			RRC		_mRFData[6]
			RRC		_mRFData[7]
			RRC		_mRFData[8]	
			JMP     Data_RRC
Data_Done:
																			
 			SET		fReceived	
 			clr		fRxstep		
 			clr		flastbit 															
	Rx_End:
           	MOV     A,mSTS1
            MOV     STATUS,A            
            MOV     A,mACC1
           	RETI	
;**************************************************************     
public _Init_RxTM
_Init_RxTM:
            MOV     A,00h		    	;fSYS/4=2MHz
            MOV     STM0C0,A        		;
            MOV     A,0C1h		    	;Timer/Counter, CCRA
            MOV     STM0C1,A        		;
            			
			MOV		A,LOW RF_RX_CNT
			MOV		STM0AL,A
			MOV		A,HIGH RF_RX_CNT
			MOV		STM0AH,A	
					
			SET		MF0E					
            SET		STM0AE
            ret   
            
CRC8:
            XORM    A,mData
            CLR     ACC
            SZ      mData.0
            XOR     A,05EH
            SZ      mData.1
            XOR     A,0BCH
            SZ      mData.2
            XOR     A,061H
            SZ      mData.3
            XOR     A,0C2H
            SZ      mData.4
            XOR     A,09DH
            SZ      mData.5
            XOR     A,023H
            SZ      mData.6
            XOR     A,046H
            SZ      mData.7
            XOR     A,08CH
            MOV     mData,A
            RET	            
            
            
            
            
         	
